<?php
$header_builder = nasa_get_headers_options();
$footer_builder = nasa_get_footers_options();
$menu_options = nasa_meta_get_list_menus();

if (is_object($term) && $term) {
    $cat_header_type = get_term_meta($term->term_id, $this->_cat_header_type);
    if (!isset($cat_header_type)) {
        $cat_header_type = add_term_meta($term->term_id, $this->_cat_header_type, '', true);
    }

    $cat_header_builder = get_term_meta($term->term_id, $this->_cat_header_builder);
    if (!isset($cat_header_builder)) {
        $cat_header_builder = add_term_meta($term->term_id, $this->_cat_header_builder, '', true);
    }

    $cat_header_vertical_menu = get_term_meta($term->term_id, $this->_cat_header_vertical_menu);
    if (!isset($cat_header_vertical_menu)) {
        $cat_header_vertical_menu = add_term_meta($term->term_id, $this->_cat_header_vertical_menu, '', true);
    }

    $cat_footer_type = get_term_meta($term->term_id, $this->_cat_footer_type);
    if (!isset($cat_footer_type)) {
        $cat_footer_type = add_term_meta($term->term_id, $this->_cat_footer_type, '', true);
    }

    $cat_footer_mobile = get_term_meta($term->term_id, $this->_cat_footer_mobile);
    if (!isset($cat_footer_mobile)) {
        $cat_footer_mobile = add_term_meta($term->term_id, $this->_cat_footer_mobile, '', true);
    }
    ?>
    <!-- Header type -->
    <tr class="form-field nasa-term-root hidden-tag term-cat_header-type-wrap">
        <th scope="row" valign="top">
            <label for="<?php echo $this->_cat_header_type; ?>"><?php esc_html_e('Override Header type', 'nasa-core'); ?></label>
        </th>
        <td>             
            <?php
            $selected = isset($cat_header_type[0]) ? $cat_header_type[0] : '';
            echo '<p><select id="' . $this->_cat_header_type . '" name="' . $this->_cat_header_type . '">';
            echo '<option value="">' . esc_html__("Default", 'nasa-core') . '</option>';
            echo '<option value="1"' . ($selected == '1' ? ' selected' : '') . '>' . esc_html__('Header Type 1', 'nasa-core') . '</option>';
            echo '<option value="2"' . ($selected == '2' ? ' selected' : '') . '>' . esc_html__('Header Type 2', 'nasa-core') . '</option>';
            echo '<option value="3"' . ($selected == '3' ? ' selected' : '') . '>' . esc_html__('Header Type 3', 'nasa-core') . '</option>';
            echo '<option value="4"' . ($selected == '4' ? ' selected' : '') . '>' . esc_html__('Header Type 4', 'nasa-core') . '</option>';
            echo '<option value="nasa-custom"' . ($selected == 'nasa-custom' ? ' selected' : '') . '>' . esc_html__('Header Builder', 'nasa-core') . '</option>';
            echo '</select></p>';
            ?>
        </td>
    </tr>
    <tr class="form-field term-cat_header-builder-wrap nasa-term-root-child <?php echo $this->_cat_header_type . ' nasa-term-' . $this->_cat_header_type . '-nasa-custom'; ?> hidden-tag">
        <th scope="row" valign="top">
            <label for="<?php echo $this->_cat_header_builder; ?>"><?php esc_html_e('Header Builder', 'nasa-core'); ?></label>
        </th>
        <td>             
            <?php
            $selected = isset($cat_header_builder[0]) ? $cat_header_builder[0] : '';
            echo '<p><select id="' . $this->_cat_header_builder . '" name="' . $this->_cat_header_builder . '">';
            foreach ($header_builder as $slug => $name) {
                echo '<option value="' . $slug . '"' . ($selected == $slug ? ' selected' : '') . '>' . $name . '</option>';
            }
            echo '</select></p>';
            ?>
        </td>
    </tr>
    <!-- End Header type -->

    <!-- Vertical Menu -->
    <tr class="form-field nasa-term-root hidden-tag term-cat_header-vertical-menu-wrap">
        <th scope="row" valign="top">
            <label for="<?php echo $this->_cat_header_vertical_menu; ?>"><?php esc_html_e('Header Vertical Menu', 'nasa-core'); ?></label>
        </th>
        <td>             
            <?php
            $selected = isset($cat_header_vertical_menu[0]) ? $cat_header_vertical_menu[0] : '';
            echo '<p><select id="' . $this->_cat_header_vertical_menu . '" name="' . $this->_cat_header_vertical_menu . '">';
            foreach ($menu_options as $id => $name) {
                echo '<option value="' . $id . '"' . ($selected == $id ? ' selected' : '') . '>' . $name . '</option>';
            }
            echo '</select></p>';
            ?>
        </td>
    </tr>
    <!-- End Vertical Menu -->

    <!-- Footer type -->
    <tr class="form-field nasa-term-root hidden-tag">
        <th scope="row" valign="top">
            <label for="<?php echo $this->_cat_footer_type; ?>"><?php esc_html_e('Override Footer type', 'nasa-core'); ?></label>
        </th>
        <td>             
            <?php
            $selected = isset($cat_footer_type[0]) ? $cat_footer_type[0] : '';
            echo '<p><select id="' . $this->_cat_footer_type . '" name="' . $this->_cat_footer_type . '">';
            foreach ($footer_builder as $slug => $name) {
                echo '<option value="' . $slug . '"' . ($selected == $slug ? ' selected' : '') . '>' . $name . '</option>';
            }
            echo '</select></p>';
            ?>
        </td>
    </tr>
    <!-- End Footer Mobile -->

    <!-- Footer type -->
    <tr class="form-field nasa-term-root hidden-tag">
        <th scope="row" valign="top">
            <label for="<?php echo $this->_cat_footer_mobile; ?>"><?php esc_html_e('Override Footer Mobile', 'nasa-core'); ?></label>
        </th>
        <td>             
            <?php
            $selected = isset($cat_footer_mobile[0]) ? $cat_footer_mobile[0] : '';
            echo '<p><select id="' . $this->_cat_footer_mobile . '" name="' . $this->_cat_footer_mobile . '">';
            foreach ($footer_builder as $slug => $name) {
                echo '<option value="' . $slug . '"' . ($selected == $slug ? ' selected' : '') . '>' . $name . '</option>';
            }
            echo '</select></p>';
            ?>
        </td>
    </tr>
    <!-- End Footer Mobile -->
    <?php
} else {
    ?>
    <!-- Header type -->
    <div class="form-field term-cat_header-type-wrap nasa-term-root hidden-tag">
        <label for="<?php echo $this->_cat_header_type; ?>"><?php esc_html_e('Override Header type', 'nasa-core'); ?></label>
        <?php
        echo '<p><select id="' . $this->_cat_header_type . '" name="' . $this->_cat_header_type . '">';
        echo '<option value="">' . esc_html__("Default", 'nasa-core') . '</option>';
        echo '<option value="1">' . esc_html__('Header Type 1', 'nasa-core') . '</option>';
        echo '<option value="2">' . esc_html__('Header Type 2', 'nasa-core') . '</option>';
        echo '<option value="3">' . esc_html__('Header Type 3', 'nasa-core') . '</option>';
        echo '<option value="4">' . esc_html__('Header Type 4', 'nasa-core') . '</option>';
        echo '<option value="nasa-custom">' . esc_html__('Header Builder', 'nasa-core') . '</option>';
        echo '</select></p>';
        ?>
    </div>
    <div class="form-field term-cat_header-builder-wrap nasa-term-root-child <?php echo $this->_cat_header_type . ' nasa-term-' . $this->_cat_header_type . '-nasa-custom'; ?> hidden-tag">
        <label for="<?php echo $this->_cat_header_builder; ?>"><?php esc_html_e('Header Builder', 'nasa-core'); ?></label>
        <?php
        echo '<p><select id="' . $this->_cat_header_builder . '" name="' . $this->_cat_header_builder . '">';
        foreach ($header_builder as $slug => $name) {
            echo '<option value="' . $slug . '">' . $name . '</option>';
        }
        echo '</select></p>';
        ?>
    </div>
    <!-- End Header type -->

    <!-- Vertical Menu -->
    <div class="form-field term-cat_header-vertical-menu-wrap nasa-term-root hidden-tag">
        <label for="<?php echo $this->_cat_header_vertical_menu; ?>"><?php esc_html_e('Header Vertical Menu', 'nasa-core'); ?></label>
        <?php
        echo '<p><select id="' . $this->_cat_header_vertical_menu . '" name="' . $this->_cat_header_vertical_menu . '">';
        foreach ($menu_options as $id => $name) {
            echo '<option value="' . $id . '">' . $name . '</option>';
        }
        echo '</select></p>';
        ?>
    </div>
    <!-- Vertical Menu -->

    <!-- Footer type -->
    <div class="form-field nasa-term-root hidden-tag">
        <label for="<?php echo $this->_cat_footer_type; ?>"><?php esc_html_e('Override Footer type', 'nasa-core'); ?></label>
        <?php
        echo '<p><select id="' . $this->_cat_footer_type . '" name="' . $this->_cat_footer_type . '">';
        foreach ($footer_builder as $slug => $name) {
            echo '<option value="' . $slug . '">' . $name . '</option>';
        }
        echo '</select></p>';
        ?>
    </div>
    <!-- End Footer type -->

    <!-- Footer mobile -->
    <div class="form-field nasa-term-root hidden-tag">
        <label for="<?php echo $this->_cat_footer_mobile; ?>"><?php esc_html_e('Override Footer Mobile', 'nasa-core'); ?></label>
        <?php
        echo '<p><select id="' . $this->_cat_footer_mobile . '" name="' . $this->_cat_footer_mobile . '">';
        foreach ($footer_builder as $slug => $name) {
            echo '<option value="' . $slug . '">' . $name . '</option>';
        }
        echo '</select></p>';
        ?>
    </div>
    <!-- End Footer mobile -->
    <?php
}
