<div class="form-field term-logo-wrap with-logo_type nasa-term-root hidden-tag">
    <label><?php _e('Override Logo', 'nasa-core'); ?></label>
    <div id="nasa-logo_thumbnail" style="float: left; margin-right: 10px;">
        <img src="<?php echo esc_url(wc_placeholder_img_src()); ?>" height="60" />
    </div>

    <div style="line-height: 60px;">
        <input type="hidden" id="<?php echo $this->_cat_logo; ?>" name="<?php echo $this->_cat_logo; ?>" />
        <button type="button" class="upload_image_button_logo button"><?php _e('Upload/Add image', 'nasa-core'); ?></button>
        <button type="button" class="remove_image_button_logo button"><?php _e('Remove image', 'nasa-core'); ?></button>
    </div>
    <div class="clear"></div>
</div>

<div class="form-field term-logo-retina-wrap with-logo-retina_type nasa-term-root hidden-tag">
    <label><?php _e('Override Logo Retina', 'nasa-core'); ?></label>
    <div id="nasa-logo-retina_thumbnail" style="float: left; margin-right: 10px;">
        <img src="<?php echo esc_url(wc_placeholder_img_src()); ?>" height="60" />
    </div>

    <div style="line-height: 60px;">
        <input type="hidden" id="<?php echo $this->_cat_logo_retina; ?>" name="<?php echo $this->_cat_logo_retina; ?>" />
        <button type="button" class="upload_image_button_logo_retina button"><?php _e('Upload/Add image', 'nasa-core'); ?></button>
        <button type="button" class="remove_image_button_logo_retina button"><?php _e('Remove image', 'nasa-core'); ?></button>
    </div>
    <div class="clear"></div>
</div>

<script>
    jQuery(document).ready(function ($){
        // Only show the "remove image" button when needed
        if (!$('#<?php echo $this->_cat_logo; ?>').val() || $('#<?php echo $this->_cat_logo; ?>').val() === '0') {
            $('.remove_image_button_logo').hide();
        }

        if (!$('#<?php echo $this->_cat_logo_retina; ?>').val() || $('#<?php echo $this->_cat_logo_retina; ?>').val() === '0') {
            $('.remove_image_button_logo_retina').hide();
        }

        // Uploading files
        var file_frame_logo;

        /**
         * Logo
         */
        $('body').on('click', '.upload_image_button_logo', function (event) {

            event.preventDefault();

            // If the media frame already exists, reopen it.
            if (file_frame_logo) {
                file_frame_logo.open();
                return;
            }

            // Create the media frame.
            file_frame_logo = wp.media.frames.downloadable_file = wp.media({
                title: '<?php _e("Choose an image", "nasa-core"); ?>',
                button: {
                    text: '<?php _e("Use image", "nasa-core"); ?>'
                },
                multiple: false
            });

            // When an image is selected, run a callback.
            file_frame_logo.on('select', function () {
                var attachment = file_frame_logo.state().get('selection').first().toJSON();
                var attachment_thumbnail = attachment.sizes.thumbnail || attachment.sizes.full;

                $('#<?php echo $this->_cat_logo; ?>').val(attachment.id);
                $('#nasa-logo_thumbnail').find('img').attr('src', attachment_thumbnail.url);
                $('.remove_image_button_logo').show();
            });

            // Finally, open the modal.
            file_frame_logo.open();
        });

        $('body').on('click', '.remove_image_button_logo', function () {
            $('#nasa-logo_thumbnail').find('img').attr('src', '<?php echo esc_js(wc_placeholder_img_src()); ?>');
            $('#<?php echo $this->_cat_logo; ?>').val('');
            $('.remove_image_button_logo').hide();
            return false;
        });

        // Uploading files retina
        var file_frame_logo_retina;

        /**
         * Logo Retina
         */
        $('body').on('click', '.upload_image_button_logo_retina', function (event) {

            event.preventDefault();

            // If the media frame already exists, reopen it.
            if (file_frame_logo_retina) {
                file_frame_logo_retina.open();
                return;
            }

            // Create the media frame.
            file_frame_logo_retina = wp.media.frames.downloadable_file = wp.media({
                title: '<?php _e("Choose an image", "nasa-core"); ?>',
                button: {
                    text: '<?php _e("Use image", "nasa-core"); ?>'
                },
                multiple: false
            });

            // When an image is selected, run a callback.
            file_frame_logo_retina.on('select', function () {
                var attachment = file_frame_logo_retina.state().get('selection').first().toJSON();
                var attachment_thumbnail = attachment.sizes.thumbnail || attachment.sizes.full;

                $('#<?php echo $this->_cat_logo_retina; ?>').val(attachment.id);
                $('#nasa-logo-retina_thumbnail').find('img').attr('src', attachment_thumbnail.url);
                $('.remove_image_button_logo_retina').show();
            });

            // Finally, open the modal.
            file_frame_logo_retina.open();
        });

        $('body').on('click', '.remove_image_button_logo_retina', function () {
            $('#nasa-logo-retina_thumbnail').find('img').attr('src', '<?php echo esc_js(wc_placeholder_img_src()); ?>');
            $('#<?php echo $this->_cat_logo_retina; ?>').val('');
            $('.remove_image_button_logo_retina').hide();
            return false;
        });

        $(document).ajaxComplete(function (event, request, options) {
            if (request && 4 === request.readyState && 200 === request.status && options.data && 0 <= options.data.indexOf('action=add-tag')) {

                var res = wpAjax.parseAjaxResponse(request.responseXML, 'ajax-response');
                if (!res || res.errors) {
                    return;
                }
                // Clear Thumbnail fields on submit
                $('#nasa-logo_thumbnail').find('img').attr('src', '<?php echo esc_js(wc_placeholder_img_src()); ?>');
                $('#nasa-logo-retina_thumbnail').find('img').attr('src', '<?php echo esc_js(wc_placeholder_img_src()); ?>');
                $('#<?php echo $this->_cat_logo; ?>').val('');
                $('#<?php echo $this->_cat_logo_retina; ?>').val('');
                $('.remove_image_button_logo').hide();
                $('.remove_image_button_logo_retina').hide();
                // Clear Display type field on submit
                $('#display_type').val('');
                return;
            }
        });
    });
</script>
