var product_load_flag = false;
var nasa_ajax_setup = true;
var nasa_iOS = nasa_check_iOS(),
    _nasa_event = (nasa_iOS) ? 'click, mousemove' : 'click';
var nasa_countdown_init = '0';
var changeDVnasa = 848;

/**
 * Document nasa-core ready
 */
jQuery(document).ready(function($) {
"use strict";

loadingSlickHasExtraVerticalNasaCore($);
loadingSlickVerticalCategories($);
loadingSlickSlidersNasaCore($);
loadingSlickSliders_TitleNasaCore($);
initVariablesProducts($);

/* Carousel - Slick Slider */
loading_slick_element($);

/**
 * init Select2
 */
nasa_init_select2($);

/**
 * NasaTip
 */
nasaTip($);

/**
 * nasa-gift-featured-event
 */
initNasaGiftFeatured($);

/**
 * Tag clouds
 */
nasaRenderTagClouds($);

/**
 * Trigger after load ajax
 */
$('body').on('nasa_after_load_ajax', function(){
    /**
     * 
     * Slick slider
     */
    loading_slick_element($);

    /**
     * 
     * Tags Cloud
     */
    nasaRenderTagClouds($);

    /**
     * nasa-gift-featured-event
     */
    initNasaGiftFeatured($);

    /**
     * Reload Select 2
     */
    nasa_init_select2($);
    nasa_init_filter_nasa_categories($);

    /**
     * Compatible Jetpack
     */
    nasaCompatibleJetpack($);

    /**
     * Countdown
     */
    loadCountDownNasaCore($);
    
    /**
     * Nasa Tip
     * 
     * @returns {undefined}
     */
    nasaTip($);

    /**
     * init variations product
     * 
     * @returns {undefined}
     */
    setTimeout(function () {
        initVariablesProducts($);

        if ($('.nasa-product-content-variable-warp').length) {
            $('.nasa-product-content-variable-warp').each(function() {
                var _this = $(this);
                if (!$(_this).hasClass('nasa-inited')) {
                    $(_this).addClass('nasa-inited');
                    change_image_content_product_variable($, _this, false);
                }
            });
        }
    }, 100);
});

$('body').on('nasa_after_load_ajax_timeout', function() {
    nasa_load_ajax_funcs($);
});

/**
 * Click Variants toggle variations product in grid
 */
$('body').on('click', '.nasa-variants-before-click', function() {
    var _click = $(this);
    var _wrap = $(_click).parents('.product-item');

    if (!$(_click).hasClass('loading')) {
        $(_click).addClass('loading');

        if ($(_wrap).find('.nasa-variations-ux-after').length) {
            if (
                typeof nasa_ajax_params !== 'undefined' &&
                typeof nasa_ajax_params.wc_ajax_url !== 'undefined'
            ) {
                var _urlAjax = nasa_ajax_params.wc_ajax_url.toString().replace('%%endpoint%%', 'nasa_call_variations_product');

                var _pid = $(_click).attr('data-product_id');

                if (_pid) {
                    $.ajax({
                        url : _urlAjax,
                        type: 'post',
                        dataType: 'json',
                        cache: false,
                        data: {
                            'pid': _pid
                        },
                        beforeSend: function() {
                            if ($(_wrap).length && $(_wrap).find('.nasa-loader').length <= 0) {
                                $(_wrap).append('<div class="nasa-light-fog"></div><div class="nasa-loader"></div>');
                            }
                        },
                        success: function(res) {
                            if (typeof res.empty !== 'undefined' && res.empty === '0') {
                                var _variants_content = '<div class="nasa-fog-variants"></div><div class="nasa-toggle-variants"><a class="nasa-close-variants" href="javascript:void(0);"></a>' + res.variable_str + '</div>';
                                $('.nasa-variations-ux-after.nasa-product-' + _pid).replaceWith(_variants_content);

                                if ($('.nasa-product-content-variable-warp').length) {
                                    $('.nasa-product-content-variable-warp').each(function() {
                                        var _this = $(this);
                                        if (!$(_this).hasClass('nasa-inited')) {
                                            $(_this).addClass('nasa-inited');
                                            change_image_content_product_variable($, _this, false);
                                        }
                                    });
                                }
                            }

                            var _variants = $(_wrap).find('.nasa-toggle-variants');
                            if ($(_variants).length) {
                                if (!$(_variants).hasClass('nasa-open')) {
                                    $(_variants).addClass('nasa-open');
                                }
                            }

                            var _fog = $(_wrap).find('.nasa-fog-variants');
                            if ($(_fog).length) {
                                if (!$(_fog).hasClass('nasa-open')) {
                                    $(_fog).addClass('nasa-open');
                                }
                            }

                            $(_wrap).find('.nasa-loader, .color-overlay, .nasa-dark-fog, .nasa-light-fog').remove();
                            $(_click).removeClass('loading');
                        },
                        error: function() {
                            $(_wrap).find('.nasa-loader, .color-overlay, .nasa-dark-fog, .nasa-light-fog').remove();
                            $(_click).removeClass('loading');
                        }
                    });
                }
            }
        } else {
            var _variants = $(_wrap).find('.nasa-toggle-variants');
            if ($(_variants).length) {
                if (!$(_variants).hasClass('nasa-open')) {
                    $(_variants).addClass('nasa-open');
                }
            }

            var _fog = $(_wrap).find('.nasa-fog-variants');
            if ($(_fog).length) {
                if (!$(_fog).hasClass('nasa-open')) {
                    $(_fog).addClass('nasa-open');
                }
            }

            $(_click).removeClass('loading');
        }
    } else {
        return false;
    }
});

/**
 * Close Variants
 */
$('body').on('click', '.nasa-close-variants', function() {
    var _wrap = $(this).parents('.product-item');

    if ($(_wrap).length) {
        var _variants = $(_wrap).find('.nasa-toggle-variants');
        if ($(_variants).length) {
            $(_variants).removeClass('nasa-open');
        }

        var _fog = $(_wrap).find('.nasa-fog-variants');
        if ($(_fog).length) {
            $(_fog).removeClass('nasa-open');
        }
    }
});

/**
 * Click Select Options Load variations product in grid
 */
$('body').on('nasa_after_click_select_option', function(e, _btn) {
    e.preventDefault();

    if (
        typeof nasa_ajax_params !== 'undefined' &&
        typeof nasa_ajax_params.wc_ajax_url !== 'undefined'
    ) {
        var _urlAjax = nasa_ajax_params.wc_ajax_url.toString().replace('%%endpoint%%', 'nasa_call_variations_product');

        var _pid = $(_btn).attr('data-product_id');

        if (_pid) {
            var _wrap = $(_btn).parents('.product-item');

            $.ajax({
                url : _urlAjax,
                type: 'post',
                dataType: 'json',
                cache: false,
                data: {
                    'pid': _pid
                },
                beforeSend: function() {
                    if ($(_wrap).length && $(_wrap).find('.nasa-loader').length <= 0) {
                        $(_wrap).append('<div class="nasa-light-fog"></div><div class="nasa-loader"></div>');
                    }
                },
                success: function(res) {
                    if (typeof res.empty !== 'undefined' && res.empty === '0') {
                        $('.nasa-variations-ux-after.nasa-product-' + _pid).replaceWith(res.variable_str);

                        if ($('.nasa-product-content-variable-warp').length) {
                            $('.nasa-product-content-variable-warp').each(function() {
                                var _this = $(this);
                                if (!$(_this).hasClass('nasa-inited')) {
                                    $(_this).addClass('nasa-inited');
                                    change_image_content_product_variable($, _this, false);
                                }
                            });
                        }

                        $(_btn).removeClass('nasa-before-click');
                    }

                    $(_wrap).find('.nasa-loader, .color-overlay, .nasa-dark-fog, .nasa-light-fog').remove();
                },
                error: function() {
                    $(_btn).removeClass('nasa-before-click');
                    $(_wrap).find('.nasa-loader, .color-overlay, .nasa-dark-fog, .nasa-light-fog').remove();
                }
            });
        }
    }
});

/**
 * Btn add to cart select option to quick view
 */
$('body').on('click', '.ajax_add_to_cart_variable', function(){
    if ($('input[name="nasa-disable-quickview-ux"]').length <= 0 || $('input[name="nasa-disable-quickview-ux"]').val() === '0') {
        $(this).parent().find('.quick-view').trigger('click');
        return false;
    } else {
        return;
    }
});

/* AJAX PRODUCTS LOAD MORE */
$('body').on('click', '.load-more-btn', function () {
    if (
        typeof nasa_ajax_params !== 'undefined' &&
        typeof nasa_ajax_params.wc_ajax_url !== 'undefined'
    ) {
        var _urlAjax = nasa_ajax_params.wc_ajax_url.toString().replace('%%endpoint%%', 'nasa_more_product');

        if (product_load_flag) {
            return;
        } else {
            product_load_flag = true;
            var _this = $(this),
                _wrap = $(_this).parents('.nasa-products-infinite-wrap'),
                _infinite = $(_wrap).find('.nasa-products-infinite'),
                _type = $(_infinite).attr('data-product-type'),
                _page = parseInt($(_infinite).attr('data-next-page')),
                _cat = $(_infinite).attr('data-cat'),
                _post_per_page = parseInt($(_infinite).attr('data-post-per-page')),
                _post_per_row = parseInt($(_infinite).attr('data-post-per-row')),
                _post_per_row_medium = parseInt($(_infinite).attr('data-post-per-row-medium')),
                _post_per_row_small = parseInt($(_infinite).attr('data-post-per-row-small')),
                _max_pages = parseInt($(_infinite).attr('data-max-pages'));
            _cat = !_cat ? null : _cat;

            $.ajax({
                url: _urlAjax,
                type: 'post',
                cache: false,
                data: {
                    page: _page,
                    type: _type,
                    cat: _cat,
                    post_per_page: _post_per_page,
                    columns_number: _post_per_row,
                    columns_number_medium: _post_per_row_medium,
                    columns_number_small: _post_per_row_small,
                    nasa_load_ajax: '1'
                },
                beforeSend: function () {
                    $(_this).before('<div class="nasa-loader" id="nasa-loader-product-infinite"></div>');
                    if (!$(_this).find('.load-more-content').hasClass('nasa-visibility-hidden')) {
                        $(_this).find('.load-more-content').addClass('nasa-visibility-hidden');
                    }
                },
                success: function (res) {
                    if (typeof res.success !== 'undefined' && res.success === '1') {
                        var _content = res.content;
                        $(_infinite).find('.nasa-row-child-clear-none').append(_content).fadeIn(1000);
                        $(_infinite).attr('data-next-page', _page + 1);
                        $('#nasa-loader-product-infinite').remove();
                        $(_this).find('.load-more-content').removeClass('nasa-visibility-hidden');

                        if (_page == _max_pages) {
                            $(_this).addClass('end-product');
                            $(_this).html('<span class="nasa-end-content">' + $(_this).attr('data-nodata') + '</span>').removeClass('load-more-btn');
                        }

                        product_load_flag = false;

                        $('body').trigger('nasa_after_load_ajax');
                        
                        setTimeout(function(){
                            $('body').trigger('nasa_after_load_ajax_timeout');
                        }, 1000);
                    }
                }
            });

            return false;
        }
    }
});

/**
 * Portfolio popup image
 */
$('body').on('click', '.portfolio-image-view', function (e) {
    var _src = $(this).attr('data-src');
    $.magnificPopup.open({
        closeOnContentClick: true,
        items: {
            src: '<div class="portfolio-lightbox"><img src="' + _src + '" /></div>',
            type: 'inline'
        }
    });
    $('.nasa-loader, .color-overlay').remove();
    e.preventDefault();
});

/**
 * Nodes Popup
 */
$('body').on('click', '.nasa-node-popup', function() {
    var _target = $(this).attr('data-target');
    if ($(_target).length) {
        /**
         * Close old Magnific
         */
        $.magnificPopup.close();

        /**
         * Open current Magnific
         */
        $.magnificPopup.open({
            mainClass: 'my-mfp-slide-bottom nasa-mfp-max-width',
            items: {
                src: _target,
                type: 'inline'
            },
            tClose: $('input[name="nasa-close-string"]').val(),
            callbacks: {
                beforeClose: function() {
                    this.st.removalDelay = 350;
                },
                afterClose: function() {

                }
            }
        });
    }
});

/**
 * Adding info product to contact form 7 ask a question
 * 
 * @type type
 */
if ($('.nasa-popup-content-contact').length) {
    $('.nasa-popup-content-contact').each(function() {
        var _this = $(this);
        if ($(_this).find('.nasa-info-add-form').length && $(_this).find('form.wpcf7-form').length) {
            $(_this).find('form.wpcf7-form').prepend($(_this).find('.nasa-info-add-form').html());
            $(_this).find('.nasa-info-add-form').remove();
        }
    });
}

if ($('.nasa-static-group-btn > a[data-target]').length) {
    $('.nasa-static-group-btn > a[data-target]').each(function() {
        var _this = $(this);
        var _target = $(_this).attr('data-target');

        if ($(_target).length) {
            $(_this).removeClass('hidden-tag');
        } else {
            $(_this).remove();
        }
    });
}

/**
 * Reponsive Banners
 * 
 * @type type
 */
var reponsiveMobile = setTimeout(function() {
    responsiveBanners($);
}, 50);

$(window).resize(function () {
    clearTimeout(reponsiveMobile);
    reponsiveMobile = setTimeout(function() {
        responsiveBanners($);
    }, 1000);
});

// Next | Prev slider
/**
 * Slick Element
 */
$('body').on('click', '.nasa-nav-icon-slider', function(){
    var _this = $(this);
    var _wrap = $(_this).parents('.nasa-slider-wrap');
    var _slider = $(_wrap).find('.nasa-slick-slider');
    if ($(_slider).length) {
        var _do = $(_this).attr('data-do');
        switch (_do) {
            case 'next':
                $(_slider).find('.slick-next').trigger('click');
                break;
            case 'prev':
                $(_slider).find('.slick-prev').trigger('click');
                break;
            default: break;
        }
    }
});

/**
 * Slick
 */
$('body').on('click', '.nasa-nav-icon-slick', function(){
    var _this = $(this);
    var _wrap = $(_this).parents('.nasa-slider-wrap');
    var _slider = $(_wrap).find('.nasa-slick-slider-body');
    if ($(_slider).length) {
        var _do = $(_this).attr('data-do');
        switch (_do) {
            case 'next':
                $(_slider).find('.slick-arrow.slick-next').trigger('click');
                break;
            case 'prev':
                $(_slider).find('.slick-arrow.slick-prev').trigger('click');
                break;
            default: break;
        }
    }
});

$('body').on('click', '.nasa-slider-deal-vertical-extra-switcher .item-slick', function() {
    var _wrap = $(this).parents('.nasa-slider-deal-vertical-extra-switcher');
    var _speed = parseInt($(_wrap).attr('data-speed'));
    _speed = !_speed ? 600 : _speed;
    $(_wrap).append('<div class="nasa-slick-fog"></div>');

    setTimeout(function(){
        $(_wrap).find('.nasa-slick-fog').remove();
    }, _speed);
});

/**
 * Countdown
 */
if (typeof nasa_countdown_l10n !== 'undefined' && (typeof nasa_countdown_init === 'undefined' || nasa_countdown_init === '0')) {
    nasa_countdown_init = '1';
    // Countdown
    $.countdown.regionalOptions[''] = {
        labels: [
            nasa_countdown_l10n.years,
            nasa_countdown_l10n.months,
            nasa_countdown_l10n.weeks,
            nasa_countdown_l10n.days,
            nasa_countdown_l10n.hours,
            nasa_countdown_l10n.minutes,
            nasa_countdown_l10n.seconds
        ],
        labels1: [
            nasa_countdown_l10n.year,
            nasa_countdown_l10n.month,
            nasa_countdown_l10n.week,
            nasa_countdown_l10n.day,
            nasa_countdown_l10n.hour,
            nasa_countdown_l10n.minute,
            nasa_countdown_l10n.second
        ],
        compactLabels: ['y', 'm', 'w', 'd'],
        whichLabels: null,
        digits: ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'],
        timeSeparator: ':',
        isRTL: true
    };

    $.countdown.setDefaults($.countdown.regionalOptions['']);
    loadCountDownNasaCore($);
}

/**
 * Color | Label | Image variations products
 */
$.fn.nasa_attr_ux_variation_form = function() {
    var clicked, selected;

    return this.each(function() {
        var $form = $(this);

        clicked = null;
        selected = [];

        $form.addClass('nasa-attr-ux-form').on('click', '.nasa-attr-ux', function(e) {
            e.preventDefault();

            var $el = $(this),
                $select = $el.closest('.variation').length ?
                    $el.closest('.variation').find('select') : $el.closest('.value').find('select'),
                attribute_name = $select.data('attribute_name') || $select.attr('name'),
                value = $el.data('value');

            if ($el.hasClass('nasa-disable') || $el.hasClass('nasa-processing') || $el.hasClass('nasa-processing-deal')) {
                return false;
            }

            else {
                $select.trigger('focusin');

                // Check if this combination is available
                if (!$select.find('option[value="' + value + '"]').length) {
                    $el.siblings('.nasa-attr-ux').removeClass('selected');
                    $select.val('').change();
                    $form.trigger('nasa-attr-ux_no_matching_variations', [$el]);
                    return;
                }

                clicked = attribute_name;

                if (selected.indexOf(attribute_name) === -1) {
                    selected.push(attribute_name);
                }

                if ($el.hasClass('selected')) {
                    $select.val('');
                    $el.removeClass('selected');

                    delete selected[selected.indexOf(attribute_name)];
                } else {
                    $el.addClass('selected').siblings('.selected').removeClass('selected');
                    $select.val(value);
                }

                $select.change();
            }

        }).on('click', '.reset_variations', function() {
            $(this).closest('.variations_form').find('.nasa-attr-ux.selected').removeClass('selected');
            selected = [];
        }).on('nasa-attr-ux_no_matching_variations', function() {
            var text_nomatch = (typeof wc_add_to_cart_variation_params !== 'undefined') ?
                wc_add_to_cart_variation_params.i18n_no_matching_variations_text :
                $('input[name="nasa_no_matching_variations"]').val();
            window.alert(text_nomatch);
        }).on('woocommerce_update_variation_values', function() {
            nasa_refresh_attrs($, $form);
        });
    });
};

$(function () {
    $('.nasa-product-details-page .variations_form').nasa_attr_ux_variation_form();
});

/**
 * Show label attribute when select vatiation
 */
$('body.nasa-label-attr-single').on('check_variations', function () {
    if ($('form.nasa-attr-ux-form').length) {
        $('form.nasa-attr-ux-form').each(function () {
            var _form = $(this);

            if ($(_form).find('table.variations tr').length) {
                $(_form).find('table.variations tr').each(function() {
                    var _this = $(this);

                    var _label = $(_this).find('td.label label');
                    var _find = $(_this).find('td.value select');

                    var _value = $(_find).val();
                    var _text = false;

                    if (_value) {
                        _text = $(_find).find('option[value="' + _value + '"]').length ? $(_find).find('option[value="' + _value + '"]').text() : _text;
                    }

                    if (_text) {
                        if ($(_label).find('.label-tip').length <= 0) {
                            $(_label).append('<span class="label-tip"></span>');
                        }

                        $(_label).find('.label-tip').html(_text);
                    } else {
                        $(_label).find('.label-tip').remove();
                    }
                });
            }
        });
    }
}).on('reset_data', function () {
    if ($('form.nasa-attr-ux-form').length) {
        $('form.nasa-attr-ux-form').each(function () {
            $(this).find('td.label label .label-tip').remove();
        });
    }
});

if ($('.nasa-product-content-variable-warp').length) {
    $('.nasa-product-content-variable-warp').each(function() {
        var _this = $(this);
        if (!$(_this).hasClass('nasa-inited')) {
            $(_this).addClass('nasa-inited');
            change_image_content_product_variable($, _this, false);
        }
    });
}

$('body').on('click', '.nasa-attr-ux-item', function() {
    var _this = $(this),
        _wrap = $(_this).parents('.nasa-product-content-child'),
        _act = $(_this).attr('data-act');

    if (!$(_this).hasClass('nasa-disable')) {
        $(_wrap).find('.nasa-attr-ux-item').removeClass('nasa-active').attr('data-act', '0');
        if (_act === '0') {
            $(_this).addClass('nasa-active').attr('data-act', '1');
        }

        var _variations_warp = $(_this).parents('.nasa-product-content-variable-warp');
        if (!$(_variations_warp).hasClass('nasa-inited')) {
            $(_variations_warp).addClass('nasa-inited');
        }

        change_image_content_product_variable($, _variations_warp, true);
    }
});

$('body').on('click', '.nasa-toggle-attr-select', function() {
    var _this = $(this);

    if ($(_this).hasClass('nasa-show')) {
        $(_this).removeClass('nasa-show');
        $(_this).parents('.nasa-product-content-child').find('.nasa-toggle-content-attr-select').slideUp(200);
    } else {
        $(_this).addClass('nasa-show');
        $(_this).parents('.nasa-product-content-child').find('.nasa-toggle-content-attr-select').slideDown(200);
    }
});

/**
 * Before pin banners
 */
$('body').on('nasa_before_pin_banners', function() {
    nasaCompatibleJetpack($);
});

/**
 * Change nasa Categories - Group products
 */
$('body').on('change', '.nasa-filter-nasa-categories', function () {
    if (
        typeof nasa_ajax_params !== 'undefined' &&
        typeof nasa_ajax_params.wc_ajax_url !== 'undefined'
    ) {
        var _urlAjax = nasa_ajax_params.wc_ajax_url.toString().replace('%%endpoint%%', 'nasa_custom_taxomomies_child');
        var _this = $(this);
        var _form = $(_this).parents('form');
        $(_form).find('.nasa-filter-nasa-categories').attr('disabled', true);
        var _taget = $(_this).attr('data-target');

        if ($(_form).find(_taget).length) {
            var _affected = $(_form).find(_taget);
            var _slug = $(_this).val();
            var _key = $(_affected).attr('data-key');
            var _hide_empty = $(_form).attr('data-hide_empty');
            var _show_count = $(_form).attr('data-show_count');
            var _active = $(_affected).parents('.nasa-wrap-select').attr('data-active');
            var _select_text = $(_affected).attr('data-text_select');

            $.ajax({
                url : _urlAjax,
                type: 'post',
                dataType: 'json',
                data: {
                    slug: _slug,
                    key: _key,
                    hide_empty: _hide_empty,
                    show_count: _show_count,
                    actived: _active,
                    select_text: _select_text
                },
                beforeSend: function(){

                },
                success: function(res){
                    if (res.success){
                        $(_affected).html(res.content);
                        if (res.empty) {
                            $(_affected).val('').change();
                        } else {
                            if (_active && res.has_active) {
                                $(_affected).val(_active).change();
                            } else {
                                $(_affected).val('').change();
                            }
                        }
                    }

                    $(_form).find('.nasa-filter-nasa-categories').attr('disabled', false);

                    nasa_init_filter_nasa_categories($);
                }
            });
        } else {
            $(_form).find('.nasa-filter-nasa-categories').attr('disabled', false);
        }
    }
});

$('body').on('click', '.nasa-submit-form', function() {
    var _form = $(this).parents('form');
    var _changed = false;
    for (var _key = 2; _key >= 0; _key--) {
        if ($(_form).find('.nasa-filter-nasa-categories.nasa-select-' + _key).length && $(_form).find('.nasa-filter-nasa-categories.nasa-select-' + _key).val() !== '') {
            var _val = $(_form).find('.nasa-filter-nasa-categories.nasa-select-' + _key).val();
            $(_form).find('input.nasa-input-main').val(_val);
            _changed = true;

            break;
        }
    }

    if (!_changed) {
        $(_form).find('input.nasa-input-main').remove();
    }

    setTimeout(function() {
        $(_form).submit();
    }, 10);


    return false;
});

/**
 * Init filter group products
 */
nasa_init_filter_nasa_categories($);

/**
 * 360 Degree Popup
 */
$('body').on('nasa_before_popup_360_degree', function() {
    $.magnificPopup.close();

    $.magnificPopup.open({
        mainClass: 'my-mfp-zoom-in',
        items: {
            src: '<div class="nasa-product-360-degree"></div>',
            type: 'inline'
        },
        tClose: $('input[name="nasa-close-string"]').val(),
        callbacks: {
            beforeClose: function() {
                this.st.removalDelay = 350;
            },
            afterClose: function() {

            }
        }
    });
});

/**
 * Show viewed sidebar
 */
var _viewed_init = false;
$('body').on('click', '#nasa-init-viewed', function() {
    if (
        !_viewed_init &&
        $('#nasa-viewed-sidebar-content').length &&
        typeof nasa_ajax_params !== 'undefined' &&
        typeof nasa_ajax_params.wc_ajax_url !== 'undefined'
    ) {
        _viewed_init = true;

        var _urlAjax = nasa_ajax_params.wc_ajax_url.toString().replace('%%endpoint%%', 'nasa_viewed_sidebar_content');

        $.ajax({
            url : _urlAjax,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {},
            success: function(res){
                if (typeof res.success !== 'undefined' && res.success === '1') {
                    $('#nasa-viewed-sidebar-content').replaceWith(res.content);

                    if ($('#nasa-viewed-sidebar').find('.item-product-widget').length) {
                        $('#nasa-viewed-sidebar').find('.nasa-sidebar-tit').removeClass('text-center');
                    }
                }
            },
            error: function() {

            }
        });
    }
});

/**
 * Check accessories product
 */
$('body').on('change', '.nasa-check-accessories-product', function () {
    var _urlAjax = null;
    if (
        typeof nasa_ajax_params !== 'undefined' &&
        typeof nasa_ajax_params.wc_ajax_url !== 'undefined'
    ) {
        _urlAjax = nasa_ajax_params.wc_ajax_url.toString().replace('%%endpoint%%', 'nasa_refresh_accessories_price');
    }

    if (_urlAjax) {
        var _this = $(this);

        var _wrap = $(_this).parents('.nasa-accessories-check');

        var _id = $(_this).val();
        var _isChecked = $(_this).is(':checked');

        var _price = $(_wrap).find('.nasa-check-main-product').length ? parseInt($(_wrap).find('.nasa-check-main-product').attr('data-price')) : 0;
        if ($(_wrap).find('.nasa-check-accessories-product').length) {
            $(_wrap).find('.nasa-check-accessories-product').each(function() {
                if ($(this).is(':checked')) {
                    _price += parseInt($(this).attr('data-price'));
                }
            });
        }

        $.ajax({
            url: _urlAjax,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                total_price: _price
            },
            beforeSend: function () {
                $(_wrap).append('<div class="nasa-disable-wrap"></div><div class="nasa-loader"></div>');
            },
            success: function (res) {
                if (typeof res.total_price !== 'undefined') {
                    $('.nasa-accessories-total-price .price').html(res.total_price);

                    if (!_isChecked) {
                        $('.nasa-accessories-' + _id).fadeOut(200);
                    } else {
                        $('.nasa-accessories-' + _id).fadeIn(200);
                    }
                }

                $(_wrap).find('.nasa-loader, .nasa-disable-wrap').remove();
            },
            error: function () {

            }
        });
    }
});

/**
 * Add To cart accessories
 */
$('body').on('click', '.add_to_cart_accessories', function() {
    if (
        typeof nasa_ajax_params !== 'undefined' &&
        typeof nasa_ajax_params.wc_ajax_url !== 'undefined'
    ) {
        var _urlAjax = nasa_ajax_params.wc_ajax_url.toString().replace('%%endpoint%%', 'nasa_add_to_cart_accessories');
        var _this = $(this);

        var _wrap = $(_this).parents('.nasa-bought-together-wrap');
        if ($(_wrap).length) {
            var _wrapCheck = $(_wrap).find('.nasa-accessories-check');

            if ($(_wrapCheck).length) {
                var _pid = [];

                // nasa-check-main-product
                if ($(_wrapCheck).find('.nasa-check-main-product').length) {
                    _pid.push($(_wrapCheck).find('.nasa-check-main-product').val());
                }

                // nasa-check-accessories-product
                if ($(_wrapCheck).find('.nasa-check-accessories-product').length) {
                    $(_wrapCheck).find('.nasa-check-accessories-product').each(function() {
                        if ($(this).is(':checked')) {
                            _pid.push($(this).val());
                        }
                    });
                }

                if (_pid.length) {
                    $.ajax({
                        url: _urlAjax,
                        type: 'post',
                        dataType: 'json',
                        cache: false,
                        data: {
                            product_ids: _pid
                        },
                        beforeSend: function () {
                            $('.nasa-message-error').hide();
                            $(_wrap).append('<div class="nasa-disable-wrap"></div><div class="nasa-loader"></div>');
                        },
                        success: function (data) {
                            if (data && data.fragments) {
                                $.each(data.fragments, function(key, value) {
                                    $(key).replaceWith(value);
                                });

                                if ($('.cart-link').length) {
                                    $('.cart-link').trigger('click');
                                }
                            } else {
                                if (data && data.error && $('.nasa-message-error').length) {
                                    $('.nasa-message-error').html(data.message);
                                    $('.nasa-message-error').show();
                                }
                            }

                            $(_wrap).find('.nasa-loader, .nasa-disable-wrap').remove();
                        },
                        error: function () {
                            $(_wrap).find('.nasa-loader, .nasa-disable-wrap').remove();
                        }
                    });
                }
            }
        }
    }

    return false;
});

/**
 * Render instagram Feed
 */
if ($('.nasa-from-instagram-feed .sbi_item').length) {
    $('.nasa-from-instagram-feed').each(function() {
        var _wrap = $(this).parents('.nasa-intagram-wrap');

        if ($(_wrap).length && $(_wrap).find('.sbi_item').length) {

            var _type = $(_wrap).attr('data-layout');

            if ($(_wrap).find('.nasa-instagram-' + _type).length) {
                var _k = 0;
                $(_wrap).find('.sbi_item a').each(function() {
                    var _this = $(this);

                    if ($(_wrap).find('.nasa-instagram-link[data-index="' + _k + '"]').length) {
                        var _notset = $(_wrap).find('.nasa-instagram-link[data-index="' + _k + '"]');
                        var _img = $(_notset).find('img.nasa-instagram-img');

                        /**
                         * href a
                         */
                        $(_notset).attr('href', $(_this).attr('href'));

                        /**
                         * set src image
                         */
                        var _size = $(_wrap).attr('data-size');
                        var _srcset_text = $(_this).attr('data-img-src-set');
                        var _src = $(_this).attr('data-full-res');
                        if (_srcset_text) {
                            var _srcset = JSON.parse(_srcset_text);
                            if (_srcset && typeof _srcset[_size] !== 'undefined') {
                                var _src = _srcset[_size];
                            }
                        }

                        if (_src) {
                            $(_img).attr('src', _src);
                        }

                        $(_img).attr('alt', $(_this).find('img').attr('alt'));

                        $(_notset).find('.nasa-not-set').removeClass('nasa-not-set');
                    }

                    _k++;
                });

                if ($(_wrap).find('.nasa-not-set').length) {
                    $(_wrap).find('.nasa-not-set').each (function() {
                        var _item = $(this).parents('.nasa-instagram-item');
                        if ($(_item).length) {
                            $(_item).remove();
                        }
                    });
                }
            }

            /**
             * remove default
             */
            $(_wrap).find('.nasa-from-instagram-feed').remove();

            if (_type === 'slider') {
                $(_wrap).find('.nasa-instagram-slider-wrap').addClass('nasa-slick-slider nasa-slick-nav');
                loading_slick_element($);
            }
            
            $('body').trigger('nasa_instagram_inited', [_wrap]);
        }
    });
}

/**
 * After changed Tab content
 */
$('body').on('nasa_after_changed_tab_content', function(ev, currentTab) {
    if (typeof currentTab !== 'undefined' && $(currentTab).length) {
        var nasa_slick_element = $(currentTab).find('.nasa-slick-slider');
        if ($(nasa_slick_element).length) {
            if (typeof wow_enable !== 'undefined' && wow_enable){
                if ($(nasa_slick_element).find('.wow').length) {
                    $(nasa_slick_element).find('.wow').each(function() {
                        if (!$(this).hasClass('animated')) {
                            $(this).addClass('animated');
                        }
                    });
                }
            }
            
            $(nasa_slick_element).slick('unslick');
            loading_slick_element($);
        }
    }
});

/**
 * After Slick inited
 */
$('body').on('nasa_inited_slick', function(ev, _this) {
    /**
     * CountDown in Slick
     */
    loadCountDownNasaCore($);
    
    /**
     * Ux variation in slick
     */
    if ($(_this).find('.nasa-product-content-variable-warp').length) {
        $(_this).find('.nasa-product-content-variable-warp').each(function() {
            var _this = $(this);
            if (!$(_this).hasClass('nasa-inited')) {
                $(_this).addClass('nasa-inited');
                change_image_content_product_variable($, _this, false);
            }
        });
    }
    
    /**
     * Banner in slick
     */
    if ($(_this).find('.nasa-banner-image').length) {
        $(_this).on('afterChange', function(ev, slick, currentSlide) {
            $(_this).find('.slick-slide').each(function(){
                var _item = $(this);

                if ($(_item).find('.banner-inner').length > 0){
                    var _banner = $(_item).find('.banner-inner');
                    var animation = $(_banner).attr('data-animation');

                    $(_banner).removeClass('animated').removeClass(animation).removeAttr('style');

                    if ($(_item).hasClass('slick-active')){
                        setTimeout(function(){
                            $(_banner).show();
                            $(_banner).addClass('animated').addClass(animation).css({
                                'visibility': 'visible',
                                'animation-duration': '1s',
                                'animation-delay': '0ms',
                                'animation-name': animation
                            });
                        }, 200);
                    }
                }
            });
        });
    }        
});

$('body').on('nasa_compatible_jetpack', function() {
    nasaCompatibleJetpack($);
});

$('body').on('nasa_load_slick_slider', function() {
    loading_slick_element($);
});

$('body').on('nasa_reload_slick_slider', function() {
    loading_slick_element($, true);
});

$('body').on('nasa_after_quickview_timeout', function() {
    loading_slick_element($);
    nasaTip($);
});

$('body').on('nasa_after_quickview', function() {
    loadCountDownNasaCore($);
});

$('body').on('nasa_load_countdown', function() {
    loadCountDownNasaCore($);
});

$('body').on('nasa_before_change_view', function() {
    initNasaGiftFeatured($);
    nasaTip($);
});

/**
 * After push filter categories
 */
$('body').on('nasa_after_push_cats_timeout', function() {
    if ($('.nasa-products-page-wrap .nasa-slick-slider').length) {
        $('.nasa-products-page-wrap .nasa-slick-slider').each(function() {
            var _this = $(this);
            $(_this).slick('unslick');
        });
        
        $('body').trigger('nasa_load_slick_slider');
    }
    
    $(window).trigger('resize');
});
/* =========== End Document nasa-core ready ==================== */
});
