<?php
/**
 * Custom Widgets
 */

add_action('widgets_init', 'nasa_cat_sidebar_override', 999);
function nasa_cat_sidebar_override() {
    $sidebar_cats = get_option('nasa_sidebars_cats');

    if (!empty($sidebar_cats)) {
        foreach ($sidebar_cats as $sidebar) {
            if (isset($sidebar['slug'])) {
                $name = esc_html__('Products Category: ', 'nasa-core') . (isset($sidebar['name']) ? ($sidebar['name'] . ' (' . $sidebar['slug'] . ')') : $sidebar['slug']);
                register_sidebar(array(
                    'name' => $name,
                    'id' => $sidebar['slug'],
                    'before_widget' => '<div id="%1$s" class="widget nasa-widget-store %2$s">',
                    'before_title' => '<h5 class="widget-title">',
                    'after_title' => '</h5>',
                    'after_widget' => '</div>'
                ));
            }
        }
    }
}

/**
 * WC_Widget
 *
 * @package  WooCommerce/Abstracts
 * @version  2.5.0
 * @extends  WP_Widget
 */
abstract class Nasa_Widget extends WP_Widget {

    /**
     * CSS class.
     *
     * @var string
     */
    public $widget_cssclass;

    /**
     * Widget description.
     *
     * @var string
     */
    public $widget_description;

    /**
     * Widget ID.
     *
     * @var string
     */
    public $widget_id;

    /**
     * Widget name.
     *
     * @var string
     */
    public $widget_name;

    /**
     * Settings.
     *
     * @var array
     */
    public $settings;
    
    /**
     * shortcode.
     *
     * @var text
     */
    public $shortcode;

    /**
     * Constructor.
     */
    public function __construct() {
        $widget_ops = array(
            'classname' => $this->widget_cssclass,
            'description' => $this->widget_description,
            'customize_selective_refresh' => true,
        );

        parent::__construct($this->widget_id, $this->widget_name, $widget_ops);
    }

    /**
     * Get this widgets title.
     *
     * @param array $instance Array of instance options.
     * @return string
     */
    protected function get_instance_title($instance) {
        if (isset($instance['title_widget'])) {
            return $instance['title_widget'];
        }

        if (isset($this->settings, $this->settings['title_widget'], $this->settings['title_widget']['std'])) {
            return $this->settings['title_widget']['std'];
        }

        return '';
    }

    /**
     * Output the html at the start of a widget.
     *
     * @param array $args Arguments.
     * @param array $instance Instance.
     */
    public function widget_start($args, $instance) {
        return;
        /*
        echo $args['before_widget'];

        $title = apply_filters('widget_title', $this->get_instance_title($instance), $instance, $this->id_base);

        if ($title) {
            echo $args['before_title'] . $title . $args['after_title'];
        } */
    }

    /**
     * Output the html at the end of a widget.
     *
     * @param  array $args Arguments.
     */
    public function widget_end($args) {
        return;
        // echo $args['after_widget'];
    }

    /**
     * Updates a particular instance of a widget.
     *
     * @see    WP_Widget->update
     * @param  array $new_instance New instance.
     * @param  array $old_instance Old instance.
     * @return array
     */
    public function update($new_instance, $old_instance) {

        $instance = $old_instance;

        if (empty($this->settings)) {
            return $instance;
        }

        // Loop settings and get values to save.
        foreach ($this->settings as $key => $setting) {
            if (!isset($setting['type'])) {
                continue;
            }

            // Format the value based on settings type.
            switch ($setting['type']) {
                case 'textarea':
                    $instance[$key] = wp_kses(trim(wp_unslash($new_instance[$key])), wp_kses_allowed_html('post'));
                    break;
                case 'checkbox':
                    $instance[$key] = empty($new_instance[$key]) ? 0 : 1;
                    break;
                default:
                    $instance[$key] = isset($new_instance[$key]) ? sanitize_text_field($new_instance[$key]) : $setting['std'];
                    break;
            }

            /**
             * Sanitize the value of a setting.
             */
            $instance[$key] = apply_filters('nasa_widget_settings_sanitize_option', $instance[$key], $new_instance, $key, $setting);
        }

        return $instance;
    }

    /**
     * Outputs the settings update form.
     *
     * @see   WP_Widget->form
     *
     * @param array $instance Instance.
     */
    public function form($instance) {

        if (empty($this->settings)) {
            return;
        }

        foreach ($this->settings as $key => $setting) {

            $class = isset($setting['class']) ? $setting['class'] : '';
            $value = isset($instance[$key]) ? $instance[$key] : $setting['std'];

            switch ($setting['type']) {

                case 'text':
                    ?>
                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id($key)); ?>"><?php echo wp_kses_post($setting['label']); ?></label><?php // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped  ?>
                        <input class="widefat <?php echo esc_attr($class); ?>" id="<?php echo esc_attr($this->get_field_id($key)); ?>" name="<?php echo esc_attr($this->get_field_name($key)); ?>" type="text" value="<?php echo esc_attr($value); ?>" />
                    </p>
                    <?php
                    break;

                case 'select':
                    ?>
                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id($key)); ?>"><?php echo $setting['label']; /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?></label>
                        <select class="widefat <?php echo esc_attr($class); ?>" id="<?php echo esc_attr($this->get_field_id($key)); ?>" name="<?php echo esc_attr($this->get_field_name($key)); ?>">
                            <?php foreach ($setting['options'] as $option_key => $option_value) : ?>
                                <option value="<?php echo esc_attr($option_key); ?>" <?php selected($option_key, $value); ?>><?php echo esc_html($option_value); ?></option>
                    <?php endforeach; ?>
                        </select>
                    </p>
                    <?php
                    break;

                case 'textarea':
                    ?>
                    <p>
                        <label for="<?php echo esc_attr($this->get_field_id($key)); ?>"><?php echo $setting['label']; /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?></label>
                        <textarea class="widefat <?php echo esc_attr($class); ?>" id="<?php echo esc_attr($this->get_field_id($key)); ?>" name="<?php echo esc_attr($this->get_field_name($key)); ?>" cols="20" rows="3"><?php echo esc_textarea($value); ?></textarea>
                        <?php if (isset($setting['desc'])) : ?>
                            <small><?php echo esc_html($setting['desc']); ?></small>
                    <?php endif; ?>
                    </p>
                    <?php
                    break;

                case 'checkbox':
                    ?>
                    <p>
                        <input class="checkbox <?php echo esc_attr($class); ?>" id="<?php echo esc_attr($this->get_field_id($key)); ?>" name="<?php echo esc_attr($this->get_field_name($key)); ?>" type="checkbox" value="1" <?php checked($value, 1); ?> />
                        <label for="<?php echo esc_attr($this->get_field_id($key)); ?>"><?php echo $setting['label']; /* phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped */ ?></label>
                    </p>
                    <?php
                    break;

                // Default: run an action.
                default:
                    do_action('nasa_widget_field_' . $setting['type'], $key, $value, $setting, $instance);
                    break;
            }
        }
    }
    
    /**
     * 
     * @param type $atts
     */
    public function render_shortcode_text($atts = array()) {
        if (!$this->shortcode || !shortcode_exists($this->shortcode)) {
            return;
        }
        
        $attsSC = array();
        $content = '';
        $text = '';
        if (!empty($atts)) {
            foreach ($atts as $key => $value) {
                if ($key === 'title_widget') {
                    continue;
                }
                
                if ($key !== 'content') {
                    $attsSC[] = $key . '="' . $value . '"';
                } else {
                    $content = $value;
                }
            }
        }
        
        $text .= '[' . $this->shortcode;
        $text .= !empty($attsSC) ? ' ' . implode(' ', $attsSC) : '';
        $text .= trim($content) != '' ? ']' . esc_html($content) . '[/' . $this->shortcode : '';
        $text .= ']';
        
        echo do_shortcode($text);
    }
    
    /**
     * Array Options Yes | No number
     */
    protected function array_bool_number() {
        return array(
            '0' => esc_html__('No', 'nasa-core'),
            '1' => esc_html__('Yes', 'nasa-core')
        );
    }
    
    /**
     * Array Options Yes | No String
     */
    protected function array_bool_str() {
        return array(
            'false' => esc_html__('No', 'nasa-core'),
            'true' => esc_html__('Yes', 'nasa-core')
        );
    }
    
    /**
     * Array Options Number
     */
    protected function array_numbers($max, $min = 1) {
        $result = array();
        
        for ($max; $max >= $min; $max--) {
            $result[$max] = $max;
        }
        
        return $result;
    }
}

/* Check if Elementor active */
defined('NASA_ELEMENTOR_ACTIVE') or define('NASA_ELEMENTOR_ACTIVE', defined('ELEMENTOR_PATH') && ELEMENTOR_PATH);
if (NASA_ELEMENTOR_ACTIVE) {
    /**
     * Includes Widgets
     */
    nasa_includes_files(glob(NASA_CORE_PLUGIN_PATH . 'includes/widgets/nasa_*.php'));
}
