<?php
$layout_buttons_class = '';
if (isset($nasa_opt['loop_layout_buttons']) && $nasa_opt['loop_layout_buttons'] != '') {
    $layout_buttons_class = ' nasa-' . $nasa_opt['loop_layout_buttons'];
}

$arrows = isset($arrows) ? $arrows : 0;
$auto_slide = isset($auto_slide) ? $auto_slide : 'true';

$_delay = 0;
$_delay_item = (isset($nasa_opt['delay_overlay']) && (int) $nasa_opt['delay_overlay']) ? (int) $nasa_opt['delay_overlay'] : 100;

$height_auto = !isset($height_auto) ? 'true' : $height_auto;

$dots = isset($dots) ? $dots : 'false';

$cat_info = apply_filters('nasa_loop_categories_show', false);
$description_info = apply_filters('nasa_loop_short_description_show', false);
?>

<div class="nasa-warp-slide-nav-top title-align-left nasa-slider-wrap">
    <div class="nasa-title">
        <h2 class="nasa-title-heading">
            <?php echo $title; ?>
        </h2>

        <?php if ($arrows == 1) : ?>
            <div class="nasa-nav-carousel-wrap">
                <a class="nasa-nav-icon-slider pe-7s-angle-left" href="javascript:void(0);" data-do="prev"></a>
                <a class="nasa-nav-icon-slider pe-7s-angle-right" href="javascript:void(0);" data-do="next"></a>
            </div>
        <?php endif; ?>
    </div>

    <?php if ($desc_shortcode) : ?>
        <p class="nasa-desc">
            <?php echo $desc_shortcode; ?>
        </p>
    <?php endif; ?>

    <div class="nasa-deal-for-time">
        <div class="nasa-sc-pdeal-countdown">
            <?php echo nasa_time_sale($deal_time, false); ?>
        </div>
    </div>
        
    <div class="nasa-slide-special-product-deal-for-time">
        <div
            class="nasa-slider-items-margin nasa-slick-slider products grid<?php echo esc_attr($layout_buttons_class); ?>"
            data-autoplay="<?php echo esc_attr($auto_slide); ?>"
            data-columns="<?php echo (int) $columns_number; ?>"
            data-columns-small="<?php echo (int) $columns_number_small; ?>"
            data-columns-tablet="<?php echo (int) $columns_number_tablet; ?>"
            data-switch-tablet="<?php echo nasa_switch_tablet(); ?>"
            data-switch-desktop="<?php echo nasa_switch_desktop(); ?>">
            <?php
            while ($specials->have_posts()) :
                $specials->the_post();
                global $product;
                
                wc_get_template(
                    'content-product.php',
                    array(
                        'is_deals' => false,
                        '_delay' => $_delay,
                        'wrapper' => 'div',
                        'show_in_list' => false,
                        'cat_info' => $cat_info,
                        'description_info' => $description_info
                    )
                );

                $_delay += $_delay_item;
            endwhile;
            
            wp_reset_postdata();
            ?>
        </div>
    </div>
</div>
