<?php
/**
 * Auto load includes files function
 */
function nasa_includes_files($files = array(), $args = array()) {
    if (!empty($files)) {
        if (!empty($args)) {
            extract($args);
        }
        
        foreach ($files as $file) {
            require_once $file;
        }
    }
}

/**
 * Include Layout
 * 
 * @param type $path
 * @param type $nasa_args
 */
function nasa_template($path, $nasa_args = array()) {
    /**
     * Check file template in child theme
     */
    $file = NASA_THEME_CHILD_PATH . '/nasa-core/' . $path;
    if (!is_file($file)) {
        $file = NASA_CORE_LAYOUTS . $path;
    }
    
    if (is_file($file)) {
        /**
         * Extract variants
         */
        if (!empty($nasa_args)) {
            extract($nasa_args);
        }

        /**
         * Call $nasa_opt
         */
        if (!isset($nasa_opt)) {
            global $nasa_opt;
        }

        /**
         * Include file
         */
        include $file;
    }
    
    /**
     * Clear $nasa_args
     */
    unset($nasa_args);
}

/**
 * Mobile Detect
 */
require_once NASA_CORE_PLUGIN_PATH . 'nasa_mobile_detect.php';

/**
 * Abstract files
 */
nasa_includes_files(glob(NASA_CORE_PLUGIN_PATH . 'abstracts/nasa_*.php'));

/**
 * Back-end
 */
if (NASA_CORE_IN_ADMIN) {
    nasa_includes_files(glob(NASA_CORE_PLUGIN_PATH . 'admin/incls/nasa_*.php'));
}

/**
 * Includes Short-codes
 */
nasa_includes_files(glob(NASA_CORE_PLUGIN_PATH . 'includes/shortcodes/nasa_*.php'));

/**
 * After setup theme
 */
add_action('after_setup_theme', 'nasa_setup');
function nasa_setup() {
    /**
     * Check Nasa Theme Active
     */
    define('NASA_THEME_ACTIVE', function_exists('elessi_setup'));
    
    /**
     * When deactive WPBakery
     */
    if (!class_exists('Vc_Manager')) {
        nasa_includes_files(glob(NASA_CORE_PLUGIN_PATH . 'includes/shortcodes_vc/nasa_*.php'));
    }
    
    /**
     * Includes shortcode and custom
     */
    nasa_includes_files(glob(NASA_CORE_PLUGIN_PATH . 'includes/incls/nasa_*.php'));
    
    /**
     * Include custom post-type
     */
    nasa_includes_files(glob(NASA_CORE_PLUGIN_PATH . 'post_type/incls/nasa_*.php'));
}

/**
 * Script nasa-core
 */
add_action('wp_enqueue_scripts', 'nasa_core_scripts_libs', 11);
function nasa_core_scripts_libs() {
    global $nasa_opt;
    
    /**
     * Cookie
     */
    if (!wp_script_is('jquery-cookie')) {
        wp_enqueue_script('jquery-cookie', NASA_CORE_PLUGIN_URL . 'assets/js/min/jquery.cookie.min.js', array('jquery'), null, true);
    }
    
    /**
     * Magnigic popup
     */
    if (!wp_script_is('jquery-magnific-popup')) {
        wp_enqueue_script('jquery-magnific-popup', NASA_CORE_PLUGIN_URL . 'assets/js/min/jquery.magnific-popup.min.js', array('jquery'), null, true);
    }
    
    /**
     * Countdown
     */
    if (!wp_script_is('countdown')) {
        wp_enqueue_script('countdown', NASA_CORE_PLUGIN_URL . 'assets/js/min/countdown.min.js', array('jquery'), null, true);
        wp_localize_script(
            'countdown', 'nasa_countdown_l10n',
            array(
                'days'      => esc_html__('Days', 'nasa-core'),
                'months'    => esc_html__('Months', 'nasa-core'),
                'weeks'     => esc_html__('Weeks', 'nasa-core'),
                'years'     => esc_html__('Years', 'nasa-core'),
                'hours'     => esc_html__('Hours', 'nasa-core'),
                'minutes'   => esc_html__('Mins', 'nasa-core'),
                'seconds'   => esc_html__('Secs', 'nasa-core'),
                'day'       => esc_html__('Day', 'nasa-core'),
                'month'     => esc_html__('Month', 'nasa-core'),
                'week'      => esc_html__('Week', 'nasa-core'),
                'year'      => esc_html__('Year', 'nasa-core'),
                'hour'      => esc_html__('Hour', 'nasa-core'),
                'minute'    => esc_html__('Min', 'nasa-core'),
                'second'    => esc_html__('Sec', 'nasa-core')
            )
        );
    }
    
    /**
     * Slick slider
     */
    if (!wp_script_is('jquery-slick')) {
        wp_enqueue_script('jquery-slick', NASA_CORE_PLUGIN_URL . 'assets/js/min/jquery.slick.min.js', array('jquery'), null, true);
    }
    
    /**
     * Select2
     */
    if (class_exists('WooCommerce') && !wp_script_is('select2')) {
        wp_enqueue_script('select2', WC()->plugin_url() . '/assets/js/select2/select2.full.min.js', array('jquery'), null, true);
        wp_enqueue_style('select2');
    }
}

/**
 * Masonry isotope Archive Product
 */
add_action('nasa_before_archive_products', 'nasa_masonry_isotope_archive_product');
function nasa_masonry_isotope_archive_product() {
    global $nasa_opt;
    
    if (isset($nasa_opt['products_layout_style']) && $nasa_opt['products_layout_style'] == 'masonry-isotope') {
        /**
         * Masonry isotope
         */
        if (!wp_script_is('jquery-masonry-isotope')) {
            wp_enqueue_script('jquery-masonry-isotope', NASA_CORE_PLUGIN_URL . 'assets/js/min/jquery.masonry-isotope.min.js', array('jquery'), null, true);
        }
    }
}

/**
 * Masonry isotope Blog
 */
add_action('nasa_before_archive_blogs', 'nasa_masonry_isotope_archive_blog');
function nasa_masonry_isotope_archive_blog() {
    global $nasa_opt;
    
    if (!isset($nasa_opt['blog_type']) || $nasa_opt['blog_type'] == 'masonry-isotope') {
        /**
         * Masonry isotope
         */
        if (!wp_script_is('jquery-masonry-isotope')) {
            wp_enqueue_script('jquery-masonry-isotope', NASA_CORE_PLUGIN_URL . 'assets/js/min/jquery.masonry-isotope.min.js', array('jquery'), null, true);
        }
    }
}
    
/**
 * Script nasa-core
 */
add_action('wp_enqueue_scripts', 'nasa_core_scripts_ready', 999);
function nasa_core_scripts_ready() {
    global $nasa_opt;
    $coreVersion = isset($nasa_opt['js_theme_version']) && $nasa_opt['js_theme_version'] ? NASA_VERSION : null;
    
    wp_enqueue_script('nasa-core-functions-js', NASA_CORE_PLUGIN_URL . 'assets/js/min/nasa.functions.min.js', array('jquery'), $coreVersion, true);
    wp_enqueue_script('nasa-core-js', NASA_CORE_PLUGIN_URL . 'assets/js/min/nasa.script.min.js', array('jquery'), $coreVersion, true);
    
    /**
     * Define ajax options
     */
    if (!defined('NASA_AJAX_OPTIONS')) {
        define('NASA_AJAX_OPTIONS', true);
        
        $ajax_params_options = array(
            'ajax_url' => esc_url(admin_url('admin-ajax.php'))
        );
        
        if (class_exists('WooCommerce')) {
            $ajax_params_options['wc_ajax_url'] = WC_AJAX::get_endpoint('%%endpoint%%');
        }
        
        $ajax_params = 'var nasa_ajax_params=' . json_encode($ajax_params_options) . ';';
        wp_add_inline_script('nasa-core-functions-js', $ajax_params, 'before');
    }
}

/**
 * Add class woo actived for body
 * Add class nasa-core actived for body
 */
add_filter('body_class', 'nasa_add_body_classes');
function nasa_add_body_classes($classes) {
    /**
     * Add class nasa-woo-actived
     */
    if (class_exists('WooCommerce') && !in_array('nasa-woo-actived', $classes)) {
        $classes[] = 'nasa-woo-actived';
    }
    
    /**
     * Add class nasa-core-actived
     */
    $classes[] = 'nasa-core-actived';
    
    return $classes;
}
