<?php
$error;
if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // No direct access allowed
final class WP_WOODMART_01 {
    private static $RTL_THEME_SLUG = 'woodmart'; // Product name
    private static $WEOWPS_RTL_OIEKS = 'd0a7e7997b6d5fcd55f4b5c32611b81';
    private static $RTL_OAUTH_PID = 45758; // Product ID
    private static $RTL_OAUTH_API = 'rtledf68e632160f6e1821e253abe5137'; // API
    private static $RTL_OPTIONS_NAME = 'woodmart1s_rtl_license_options'; // {Product_name}_rtl_license_options
    private static $RTL_SECURE_ACTIVE = 'woodmart1s_rtledf68e632160f6e1821e253abe5137'; // {API}_{Product_name}_workesactive
    private static $instance = null;
    private static $hash_method = 'AES-256-CBC';
    private $hash_key;




    public static function get_instance() {
        if ( self::$instance == null ) {
            self::$instance = new WP_WOODMART_01();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->hash_key = hash('sha256', 'd0a7e7997b6d5fcd55f4b5c32611b81');
        add_action('admin_menu', array($this, 'rtl_oauth_license_options'));

        if(@$_GET['page'] !== 'activator' && @$_GET['page'] !== 'deactivator') {
            add_action( 'admin_notices', array($this, 'sample_admin_notice__success') );
        }
        if(@$_GET['page'] == 'activator') {
            add_filter('admin_footer_text', array($this, 'rtl_change_footer_admin'));
        }
    }


    public function encrypt($data, $key, $method)
    {
        $ivSize = openssl_cipher_iv_length($method);
        $iv = openssl_random_pseudo_bytes($ivSize);

        $encrypted = openssl_encrypt($data, $method, $key, OPENSSL_RAW_DATA, $iv);

        // For storage/transmission, we simply concatenate the IV and cipher text
        $encrypted = base64_encode($iv . $encrypted);

        return $encrypted;
    }

    public function decrypt($data, $key, $method)
    {
        $data = base64_decode($data);
        $ivSize = openssl_cipher_iv_length($method);
        $iv = substr($data, 0, $ivSize);
        $data = openssl_decrypt(substr($data, $ivSize), $method, $key, OPENSSL_RAW_DATA, $iv);

        return $data;
    }





    public function rtloauthsend($api,$username,$order_id,$domain,$secret_key,$pid) {
        $url = 'http://www.rtl-theme.com/oauth/';
        $pid = $pid;
        if($pid == 'newproduct') {
            $curl_args = array(
                    'method' => 'POST',
                    'timeout' => 45,
                    'redirection' => 5,
                    'httpversion' => '1.0',
                    'blocking' => true,
                    'headers' => array(),
                    'body' => array(
                                    'api' => $api,
                                    'username' => $username,
                                    'order_id' => $order_id,
                                    'domain' => $domain,
                                    'secretkey' => $secret_key
                                ),
                    'cookies' => array()
                    );
        } else {
            $curl_args = array(
                    'method' => 'POST',
                    'timeout' => 45,
                    'redirection' => 5,
                    'httpversion' => '1.0',
                    'blocking' => true,
                    'headers' => array(),
                    'body' => array(
                                    'api' => $api,
                                    'username' => $username,
                                    'order_id' => $order_id,
                                    'domain' => $domain,
                                    'secretkey' => $secret_key,
                                    'pid' => $pid
                                ),
                    'cookies' => array()
                    );
        }

        $res = wp_remote_post( $url, $curl_args );
        
        if(WP_DEBUG == true) {
            if ( is_wp_error( $res ) ) {
               $error_message = $res->get_error_message();
               echo "Something went wrong: $error_message";
            } else {
               echo '<pre style="direction:ltr;text-align:left">';
               print_r( $res );
               echo '</pre>';
            }
        }
        return $res['body'];
    }


    public function rtl_oauth_license_options() {
        add_menu_page('فعال سازی قالب', 'فعال سازی قالب', 'administrator', 'activator', array($this, 'rtl_oauth_license_settings_page') , 'dashicons-unlock', 3 );
    }
    public function rtl_oauth_license_settings_page() {
        $rtl_activate_options = get_option(static::$RTL_OPTIONS_NAME);
        ?>
        <style>
            #wpwrap {
                background: url('data:image/jpeg;base64,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') repeat;
            }
            .rtl_logo {
                margin:  1em auto;
                position: absolute;
                top: 50px;
                <?php if(is_rtl()) { ?>
                left: 50px;
                <?php } else { ?>
                right: 50px;
                <?php } ?>
                width: 100%;
                max-width: 300px;
                text-align: center;
                border: 1px dashed #ddd;
                border-radius: 7px;
                padding: 10px;
                background: #fff;

            }
            .rtl_logo img {

                width: 80px;
                height: auto;
            }
            .rtl_logo a {
                text-decoration: none;
                text-transform: uppercase;
                color: #999;
            }
            @media only screen and (max-width: 1030px) {
                .rtl_logo {
                    position: static;
                }
            }
            #adminmenuback {
                display: none;
            }
        </style>
        <div class="wrap">
        <h1>فعال سازی قالب</h1>
        <?php
        $error = 0;
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $variable = get_option(static::$RTL_OPTIONS_NAME);
            if (!empty($variable)) {
              delete_option(static::$RTL_OPTIONS_NAME);
            }
            $username = trim(@$_POST[static::$RTL_THEME_SLUG.'_rtl_username']);
            $order_id = trim(@$_POST[static::$RTL_THEME_SLUG.'_rtl_orderid']);
            $domain = trim(esc_attr( site_url() ));
            $deactivate_key = 'rtlsecrectkey'.substr( md5( uniqid( current_time('timestamp',0) ) ), 0, 20);
            $result = $this->rtloauthsend(static::$RTL_OAUTH_API,$username,$order_id,$domain,$deactivate_key,static::$RTL_OAUTH_PID);
            if($result > 0 && is_numeric($result)){
                $variable = array(

                    static::$RTL_THEME_SLUG.'_rtl_api' => $this->encrypt(static::$RTL_OAUTH_API, $this->hash_key, static::$hash_method),
                    static::$RTL_THEME_SLUG.'_rtl_domain' => $this->encrypt($domain, $this->hash_key, static::$hash_method),
                    static::$RTL_THEME_SLUG.'_rtl_orderid' => $this->encrypt($order_id, $this->hash_key, static::$hash_method),
                    static::$RTL_THEME_SLUG.'_rtl_username' => $this->encrypt($username, $this->hash_key, static::$hash_method),
                    static::$RTL_THEME_SLUG.'_rtl_secretkey' => $this->encrypt($deactivate_key, $this->hash_key, static::$hash_method),
                    static::$RTL_THEME_SLUG.'_rtl_status' => $this->encrypt(static::$RTL_SECURE_ACTIVE, $this->hash_key, static::$hash_method)
                );
                $update = update_option(static::$RTL_OPTIONS_NAME, $variable);

                    echo '
                    <div class="notice notice-success is-dismissible">
                        <p>محصول با موفقیت فعال گردید.</p>
                    </div>';
                    /*echo '
                    <div class="notice notice-success is-dismissible">
                        <p>محصول با موفقیت فعال گردید.</p>
                    </div>
                    <div class="notice notice-error is-dismissible">
                        <p>لطفاً لینک غیرفعال سازی را در جای امنی نگه داری نمایید.</p>
                    </div>
                    <h2>برای غیر فعال کردن محصول در این دامنه از لینک زیر استفاده نمایید:</h2>
                    <table class="form-table">
                        <tr valign="top">
                            <td>
                                <input type="text" value="'.esc_attr( site_url() ).'/wp-admin/admin.php?page=deactivator&tokenkey='.$deactivate_key.'" style="width: 500px; direction:ltr" class="deactivatelink" readonly />
                                <button class="js-deactivatelinkcopybtn button button-primary" style="vertical-align: initial;">کپی لینک</button>
                            </td>
                        </tr>
                        <tr valign="top">
                            <td>
                                <a href="'.esc_attr( site_url() ).'/wp-admin/" class="button button-secondery">خروج از این برگه</a>
                            </td>
                        </tr>
                    </table>
                    <script type="text/javascript">
                        var copyTextareaBtn = document.querySelector(\'.js-deactivatelinkcopybtn\');

                        copyTextareaBtn.addEventListener(\'click\', function(event) {
                          var copyTextarea = document.querySelector(\'.deactivatelink\');
                          copyTextarea.select();

                          try {
                            var successful = document.execCommand(\'copy\');
                            var msg = successful ? \'successful\' : \'unsuccessful\';
                            //console.log(\'Copying text command was \' + msg);
                          } catch (err) {
                            //console.log(\'Oops, unable to copy\');
                          }
                        });
                    </script>';
*/
                    $error = -1;

            } else {
                if($result == '-1') {
                    $error = 1;
                    $error_msg = "کد API اشتباه است.";
                }
                if($result == '-2') {
                    $error = 1;
                    $error_msg = "نام کاربری اشتباه است.";
                }
                if($result == '-3') {
                    $error = 1;
                    $error_msg = "کد سفارش اشتباه است.";
                }
                if($result == '-4') {
                    $error = 1;
                    $error_msg = "کد سفارش قبلاً ثبت شده است.";
                }
                if($result == '-5') {
                    $error = 1;
                    $error_msg = "کد سفارش مربوط به این نام کاربری نمیباشد.";
                }
            }
        }
        if($error != -1) :
            if($error == 1) {
                ?>
                <div class="notice notice-error is-dismissible">
                    <p><?php echo $error_msg; ?></p>
                </div>
                <?php
            }
            ?>
            <form method="post">
                <table class="form-table">
                    <tr valign="top">
                    <th scope="row">نام کاربری</th>
                    <td><input type="text" name="<?php echo static::$RTL_THEME_SLUG; ?>_rtl_username" value="<?php echo @$_POST[static::$RTL_THEME_SLUG.'_rtl_username']; ?>" /></td>
                    </tr>

                    <tr valign="top">
                    <th scope="row">کد سفارش</th>
                    <td><input type="text" name="<?php echo static::$RTL_THEME_SLUG; ?>_rtl_orderid" value="<?php echo @$_POST[static::$RTL_THEME_SLUG.'_rtl_orderid']; ?>" /></td>
                    </tr>

                    <tr valign="top">
                    <th scope="row">دامنه</th>
                    <td><input type="text" name="<?php echo static::$RTL_THEME_SLUG; ?>_rtl_domain" value="<?php echo esc_attr( site_url() ); ?>" disabled /></td>
                    </tr>
                </table>

                <?php submit_button('فعال‌سازی محصول'); ?>

            </form>

            <div class="rtl_logo">
                <img src="data:image/png;base64,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" alt="Rtl-theme.com">
                <h3>راهنما</h3>
                <p>برای فعال سازی محصول کافیست <strong>نام کاربری</strong> و <strong>کد سفارش</strong> خود در <a href="http://www.rtl-theme.com" target="_blank">راست چین</a> را در فرم بالا وارد کرده و روی دکمه <strong>فعال‌سازی محصول</strong> کلیک کنید.</p>
                <a href="http://www.rtl-theme.com/license-activate-help/" target="_blank">توضیحات بیشتر</a>
                <br><br><br>
                <a href="http://www.rtl-theme.com" target="_blank">www.rtl-theme.com</a>
            </div>

            <?php
        endif;
        echo '</div>';
    }

    public function sample_admin_notice__success() {
        ?>
        <div class="notice notice-success is-dismissible">  <!-- is-dismissible -->
            <img src="data:image/png;base64,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" style="width: 60px;float: right;margin-top: 10px;margin-left: 10px;">
            <p>محصول شما فعال نشده است، برای فعل سازی <a href="<?php echo esc_attr( site_url() ); ?>/wp-admin/admin.php?page=activator">اینجا</a> کلیک کنید.</p>
            <p><br><a href="http://www.rtl-theme.com" target="_blank">راست چین</a> بزرگترین مرجع قالب های آماده فارسی</p>
        </div>
        <?php
    }


    public function rtl_change_footer_admin () {
        echo '<img src="data:image/png;base64,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" style="width: 15px;float: right;margin-left: 3px;"> از اینکه محصولات <a href="http://www.rtl-theme.com" target="_blank">راست چین</a> را برای کسب و کار خود انتخاب کرده‌اید متشکریم.';
    }
}
if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // No direct access allowed

final class WP_WOODMART_02 {
    private static $RTL_THEME_SLUG = 'woodmart'; // Product name
    private static $WEOWPS_RTL_OIEKS = 'd0a7e7997b6d5fcd55f4b5c32611b81';
  private static $RTL_OAUTH_PID = 45758; // Product ID
    private static $RTL_OAUTH_API = 'rtledf68e632160f6e1821e253abe5137'; // API
    private static $RTL_OPTIONS_NAME = 'woodmart1s_rtl_license_options'; // {Product_name}_rtl_license_options
    private static $RTL_SECURE_ACTIVE = 'woodmart1s_rtledf68e632160f6e1821e253abe5137'; // {API}_{Product_name}_workesactive
    private static $instance = null;
    private static $hash_method = 'AES-256-CBC';
    private $hash_key;

    public static function get_instance() {
        if ( self::$instance == null ) {
            self::$instance = new WP_WOODMART_02();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->hash_key = hash('sha256', 'd0a7e7997b6d5fcd55f4b5c32611b81');

        $rtl_activate_options = get_option(static::$RTL_OPTIONS_NAME);

        if(static::$RTL_SECURE_ACTIVE == $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG.'_rtl_status'],   $this->hash_key, static::$hash_method)) {
            add_action('admin_menu', array($this, 'rtl_oauth_license_deactivator'));
        }

        if(@$_GET['page'] == 'deactivator') {
            add_filter('admin_footer_text', array($this, 'rtl_change_footer_admin2'));
        }
        
    }

    public function encrypt($data, $key, $method)
    {
        $ivSize = openssl_cipher_iv_length($method);
        $iv = openssl_random_pseudo_bytes($ivSize);

        $encrypted = openssl_encrypt($data, $method, $key, OPENSSL_RAW_DATA, $iv);

        // For storage/transmission, we simply concatenate the IV and cipher text
        $encrypted = base64_encode($iv . $encrypted);

        return $encrypted;
    }

    public function decrypt($data, $key, $method)
    {
        $data = base64_decode($data);
        $ivSize = openssl_cipher_iv_length($method);
        $iv = substr($data, 0, $ivSize);
        $data = openssl_decrypt(substr($data, $ivSize), $method, $key, OPENSSL_RAW_DATA, $iv);

        return $data;
    }

    public function remove_http($url) {
       $disallowed = array('http://', 'https://');
       foreach($disallowed as $d) {
          if(strpos($url, $d) === 0) {
             return str_replace($d, '', $url);
          }
       }
       return $url;
    }

    public function rtloauthcheck() {
        $rtloauthcheckdomain = true;
        $rtl_activate_options = get_option(static::$RTL_OPTIONS_NAME);
        if(isset($rtl_activate_options[static::$RTL_THEME_SLUG.'_rtl_domain'])) {

            $dbDomain = $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG.'_rtl_domain'], $this->hash_key, static::$hash_method);
            $siteDomain = trim(esc_attr( site_url() ));
            if ( function_exists('icl_object_id') ) {
                $dbDomainParse = parse_url($dbDomain);
                $dbDomain = $dbDomainParse['host'];

                $siteDomainParse = parse_url($siteDomain);
                $siteDomain = $siteDomainParse['host'];
            }
            $siteDomain = $this->remove_http($siteDomain);
            $dbDomain = $this->remove_http($dbDomain);
            
            if( $siteDomain != $dbDomain ) {

                $variable = get_option(static::$RTL_OPTIONS_NAME);

                $status = array(
                    static::$RTL_THEME_SLUG.'_rtl_status' => $this->encrypt('rtlthemeworkesdeactive', $this->hash_key, static::$hash_method)
                );

                $options = array_merge($variable, $status);
                update_option(static::$RTL_OPTIONS_NAME, $options);

                $rtloauthcheckdomain = false;
            }

        } else {
            $rtloauthcheckdomain = false;
        }

        // || $_SERVER['HTTP_HOST'] == 'localhost'
        if($rtl_activate_options[static::$RTL_THEME_SLUG.'_rtl_status'] == $this->encrypt(static::$RTL_SECURE_ACTIVE, $this->hash_key, static::$hash_method) || $rtloauthcheckdomain != false/* || $_SERVER['HTTP_HOST'] == 'localhost' || $_SERVER['HTTP_HOST'] == '127.0.0.1'*/) {
            return true;
        }
        else
        {
            return false;
        }
    }
    public function rtloauthdeactivesend($secret_key,$username,$orderid) {
        $url = 'http://www.rtl-theme.com/oauth/deactive/';
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL,$url);
        curl_setopt($ch,CURLOPT_POSTFIELDS,"secretkey=$secret_key&username=$username&orderid=$orderid");
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        $res = curl_exec($ch);
        curl_close($ch);
        return $res;
    }
    public function rtl_oauth_license_deactivator() {
        //add_menu_page('فعال سازی قالب', 'فعالی سازی قالب', 'administrator', 'activator', 'rtl_oauth_license_deactivator_page' , 'dashicons-unlock', 3 );
        add_submenu_page('admin.php', 'غیرفعال سازی محصول', 'غیرفعال سازی محصول', 'administrator', 'deactivator', array($this, 'rtl_oauth_license_deactivator_page'));
    }

    public function rtl_oauth_license_deactivator_page() {
        $rtl_activate_options = get_option(static::$RTL_OPTIONS_NAME);
        ?>
        <style>
            #wpwrap {
                background: url('data:image/jpeg;base64,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') repeat;
            }
            .rtl_logo {
                margin:  1em auto;
                position: absolute;
                top: 50px;
                <?php if(is_rtl()) { ?>
                left: 50px;
                <?php } else { ?>
                right: 50px;
                <?php } ?>
                width: 100%;
                max-width: 300px;
                text-align: center;
                border: 1px dashed #ddd;
                border-radius: 7px;
                padding: 10px;
                background: #fff;

            }
            .rtl_logo img {
                
                width: 80px;
                height: auto;
            }
            .rtl_logo a {
                text-decoration: none;
                text-transform: uppercase;
                color: #999;
            }
            @media only screen and (max-width: 1030px) {
                .rtl_logo {
                    position: static;
                }
            }


            .modal {
                display: none; /* Hidden by default */
                position: fixed; /* Stay in place */
                z-index: 99999; /* Sit on top */
                right: 0;
                top: 0;
                width: 100%; /* Full width */
                height: 100%; /* Full height */
                overflow: auto; /* Enable scroll if needed */
                background-color: rgb(0,0,0); /* Fallback color */
                background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
                -webkit-animation-name: fadeIn; /* Fade in the background */
                -webkit-animation-duration: 0.4s;
                animation-name: fadeIn;
                animation-duration: 0.4s
            }

            /* Modal Content */
            .modal-content {
                position: fixed;
                top: 0;
                background-color: #fefefe;
                width: 100%;
                -webkit-animation-name: slideIn;
                -webkit-animation-duration: 0.4s;
                animation-name: slideIn;
                animation-duration: 0.4s;
                max-width: 500px;
                right: 50%;
                margin-right: -250px;
            }

            /* The Close Button */
            .close {
                color: white;
                float: left;
                font-size: 28px;
                font-weight: bold;
                line-height: 2;
            }

            .close:hover,
            .close:focus {
                color: #000;
                text-decoration: none;
                cursor: pointer;
            }

            .modal-header {
                padding: 2px 16px;
                background-color: #5cb85c;
                color: white;
            }
            .modal-header h2 {
                color: white;
            }

            .modal-body {padding: 2px 16px;}

            .modal-footer {
                padding: 2px 16px;
                background-color: #5cb85c;
                color: white;
            }
            .modal-footer h3 {
                color: white;
                display: inline-block;
            }

            /* Add Animation */
            @-webkit-keyframes slideIn {
                from {top: -300px; opacity: 0} 
                to {top: 0; opacity: 1}
            }

            @keyframes slideIn {
                from {top: -300px; opacity: 0}
                to {top: 0; opacity: 1}
            }

            @-webkit-keyframes fadeIn {
                from {opacity: 0} 
                to {opacity: 1}
            }

            @keyframes fadeIn {
                from {opacity: 0} 
                to {opacity: 1}
            }

            @-webkit-keyframes fadeOut {
                from {opacity: 1} 
                to {opacity: 0}
            }

            @keyframes fadeOut {
                from {opacity: 1} 
                to {opacity: 0}
            }

        </style>
        <div class="wrap">
            <h1>غیرفعال سازی محصول</h1>

            <?php
            if(isset($_GET['tokenkey'])) {
                if($_GET['tokenkey'] == $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG."_rtl_secretkey"], $this->hash_key, static::$hash_method)) {
                    if(isset($_GET['runit'])) {
                        if($_GET['runit'] == 'yes') {
                            $secret_key = $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG."_rtl_secretkey"], $this->hash_key, static::$hash_method);
                            $username = $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG."_rtl_username"], $this->hash_key, static::$hash_method);
                            $orderid = $this->decrypt($rtl_activate_options[static::$RTL_THEME_SLUG."_rtl_orderid"], $this->hash_key, static::$hash_method);
                            $result = $this->rtloauthdeactivesend($secret_key,$username,$orderid);
                            if($result > 0 && is_numeric($result)){
                                delete_option(static::$RTL_OPTIONS_NAME);
                                echo 'غیر فعال سازی با موفقیت انجام شد.';
                            } else {

                                
                                if($result == '-1') {
                                    die('متاسفانه در غیرفعال سازی محصول خطایی رخ داده است.');
                                }
                                if($result == '-2') {
                                    die('کلید غیرفعال سازی اشتباه است.');
                                }
                                if($result == '-3' || $result == '0') {
                                    die('منظور؟');
                                }
                            }
                        }
                        else {
                            die('خطایی رخ داده است!');
                        }
                    }
                    else
                    {
                    ?>

                        <br><br>
                        <ul>
                            <li>• غیرفعال سازی محصول به شما کمک میکند تا این محصول را در سایت دیگری فعال نمایید.</li>
                            <li>• طبیعی است که وب سایت فعلی شما بعد از غیرفعال سازی عملکرد درستی نخواهد داشت.</li>
                            <li>• تعداد دفعات فعال سازی محصول برای یک دامنه محدود می باشد. (لطفاً از غیرفعال کردن محصول مطمئن باشید، سپس اقدام کنید.)</li>
                        </ul>
                        <br>
                        <button id="myBtn" class="button button-primary">غیر فعال سازی محصول</button>

                        <div id="myModal" class="modal">

                          <!-- Modal content -->
                          <div class="modal-content">
                            <div class="modal-header">
                              <span class="close">&times;</span>
                              <h2>غیرفعال سازی محصول</h2>
                            </div>
                            <div class="modal-body">
                              <p>غیرفعال سازی محصول به شما کمک میکند تا این محصول را در سایت دیگری فعال نمایید.</p>
                              <p>طبیعی است که وب سایت فعلی شما بعد از غیرفعال سازی عملکرد درستی نخواهد داشت.</p>
                              <p>تعداد دفعات فعال سازی محصول برای یک دامنه محدود می باشد. (لطفاً از غیرفعال کردن محصول مطمئن باشید، سپس اقدام کنید.)</p>
                            </div>
                            <div class="modal-footer">
                              <h3>آیا این مورد را تایید مینمایید؟ </h3>
                              <div class="pull-left" style="margin-top: 10px;">
                                <a href="<?php echo esc_attr( site_url() ).'/wp-admin/admin.php?page=deactivator&tokenkey='.$_GET['tokenkey']; ?>&runit=yes" class="button button-primary">بله</a> <span class="notok button button-secondery" id="notok">خیر</span>
                              </div>
                            </div>
                          </div>

                        </div>

                        <script>
                            var modal = document.getElementById('myModal');
                            var btn = document.getElementById("myBtn");
                            var span = document.getElementsByClassName("close")[0];
                            var notok = document.getElementsByClassName("notok")[0];
                            btn.onclick = function() {
                                modal.style.display = "block";
                            }
                            span.onclick = function() {
                                modal.style.display = "none";
                            }
                            notok.onclick = function() {
                                modal.style.display = "none";
                            }
                            window.onclick = function(event) {
                                if (event.target == modal) {
                                    modal.style.display = "none";
                                }
                            }
                        </script>
                        <?php
                    }
               }
                else
                {
                    //echo mc_decrypt($rtl_activate_options[RTL_THEME_SLUG."_rtl_secretkey"], static::$WEOWPS_RTL_OIEKS);
                    die('کلید غیرفعالسازی اشتباه است!');
                }
            }
            else
            {
                die('کلید غیرفعالسازی وارد نشده است!');
            }
            ?>
        </div>

        <?php
    }
    public function rtl_change_footer_admin2 () {
        echo '<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA8AAAAPCAYAAAA71pVKAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyFpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTExIDc5LjE1ODMyNSwgMjAxNS8wOS8xMC0wMToxMDoyMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6Njg2QTI4NDdCRkJGMTFFNjg0MzJFQzYxRkRCOTVFMEEiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6Njg2QTI4NDZCRkJGMTFFNjg0MzJFQzYxRkRCOTVFMEEiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIChXaW5kb3dzKSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOjQ1RjU5RUIzRjRCODExRTU5QUI3QjBEMzVBMDQxMEM2IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjQ1RjU5RUI0RjRCODExRTU5QUI3QjBEMzVBMDQxMEM2Ii8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+05JdEAAAAlRJREFUeNp8kk1IVFEUx8+9784b56k8izCEyUT6JPtAaCGBLQrCXAQtQqpt0kKIAndtgyiQqJW064sIWrQo3egiKLNFG6carNQSmxp1csaZ8b15977b/w13Qom6vB/cd877n3vu/x1WLpfJU6uktCRGG5YFmkEUXgRBLaG1pngsQWJy4i1NLt+nXGWBLCaiXCsYAD0gacTfwRgYBqlA+nSwrZuElIr8wKeCt0g2S+whxu7hgw5zkmTENPS7sN8LLoIrEN/xA49ElOvcfJpmim9ooTw1r3TQA4FpkUXXYVJ7rsXsE4jfQPA2Z/wXY+yB0DqsS1iud6Cpl3Y0HClJHZSYEUZPCC9QNP959fVdTeE8CowgeROMCMuyLimlzoRaqbjVQPGNpkHPv+1vOjloc2d2auX5KDp4j/A+0CsymcytlpaWJAoMoAD9vdRhHP9ja2L3QLowhmuon0bcxee+zvqWJUboP4szkfNVEcLARtvtJuxyGUTe6OI/dIHFYg+l9ofShXE0EJ5HrM3k5kS+UIg2H8EqaDSJqNh1wePPSjKXepd7Skv+TLdg8aF1hV/xeqeezAQ9XpdYxonXst506mV2OLbkzw5CGF3NNfk0GOfJZLI6blhXwSeT3Ab64TQFoccxecfw7tSmE1wGazxm2zVx1ozkROQRzBlurtt5/NCmUz7+Qh80H4z4LBitGolfVBUbvoCj4Bx4UlFrF1qdzsb2+q4V7PtUKKfBCxCZR8J1XXIch6SSfxwGj6po4jCNbWcdlOdzU/ChP2pfqkrBdbbQbwEGABNKFs6sq3DCAAAAAElFTkSuQmCC" style="width: 15px;float: right;margin-left: 3px;"> از اینکه محصولات <a href="http://www.rtl-theme.com" target="_blank">راست چین</a> را برای کسب و کار خود انتخاب کرده‌اید متشکریم.';
    }

}



?>